#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "sem.h"


static long getkey32(char *name)
{
    int l,i,j,sum[8]={0};
    long int code=0;

    l=(strlen(name)-2);

    for (j=0;j<=l;j++)
    {
        i=j%8;
        sum[i]+=name[j];
     }
    
     for (j=0;j<=7;j++)
        code+=sum[j]<<(j*3);
     return code;
}


sem_t *semCreate(char *name,int initval)
{
    int sid;
    sem_t *sidptr;
    long key;
    union semun {
	int val;
	struct semid_ds *buf;
	ushort *array;
    } arg;

    arg.val = initval;
    key = getkey32(name);

    if (semget ((key_t) key, 1, 0600) != -1) {
	errno = EEXIST;    /* Can't create it if it exists */
	return (NULL);
    }

    if ((sid = semget ((key_t) key, 1, 0600 | IPC_CREAT)) == -1)
	return (NULL);	/* Error if can't create it */;
    
    semctl(sid,0,SETVAL,arg); /* Initialize value */
    sidptr = (sem_t *) malloc(sizeof(sem_t));
    *sidptr = (sem_t) sid;
    return((sem_t *)sidptr);
}

sem_t *semAttach(char *name)
{
    int sid;
    sem_t *sidptr;
    int key = getkey32(name);
    sid = semget ((key_t) key, 1, 0600 ) ;

    sidptr = (sem_t *) malloc(sizeof(int));
    *sidptr = (sem_t) sid;
    return((sem_t *) sidptr);
}

int semVal(sem_t *sidptr)
{
    return( semctl(*(int *)sidptr,0,GETVAL,0));
}

int semDestroy(sem_t *sidptr)
{
    int rv;
    rv = semctl(*(int *)sidptr,0,IPC_RMID,0);
    free(sidptr);
    return(rv); 
}

int semDetach(sem_t *sidptr)
{
    /* is this right? Nothing to do? */
    free(sidptr);
    return(0);
}

int semP(sem_t *sidptr)
{
    struct sembuf sb;
    sb.sem_num=0;
    sb.sem_op = -1; /* P subtracts 1 from semaphore value */
    sb.sem_flg= 0;   
    return (semop(*(int *)sidptr,&sb,1)); 
}

int semV(sem_t *sidptr)
{
    struct sembuf sb;

    sb.sem_op = 1;  /* V adds 1 to semaphore value*/
    sb.sem_flg= 0;
    return (semop(*(int *)sidptr,&sb,1)); 
}

int semSet(sem_t *sidptr,int val)
{
    int rv;
    union semun {
	int val;
	struct semid_ds *buf;
	ushort *array;
    } arg;

    arg.val = val;

    rv = semctl(*(int *)sidptr,0,SETVAL,arg);
    return(rv);
}
